KPL/MK

Meta-kernel for RAMSES Dataset v002 -- Study Launch 2028 Earth-Asteroid 20260206_001
============================================================================

   This meta-kernel lists the RAMSES Study Launch 2028 Earth-Asteroid SPICE kernels
   that provide information for the Study Launch 2028 Earth-Asteroid scenario.

      - Launch on October, 2028
      - Ramses study trajectory from launch to end of mission

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the RAMSES Study Launch 2028 Earth-Asteroid scenario.

   The scenario is based on the study OEM files provided by Mission
   Analysis.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v4.4.6.


Usage of the Meta-kernel
---------------------------------------------------------------------------

   This metakernel is only for science operations analysis at this stage.

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE Web server:

      https://spiftp.esac.esa.int/data/SPICE/RAMSES/kernels/

   or from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/RAMSES/kernels/


Implementation Notes
---------------------------------------------------------------------------

   DISCLAIMER: Please note that the current kernels are pre-operational and
   they are subject to change.

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the RAMSES SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on February 6, 2026 by Alfredo Escalante Lopez ESA/ESAC.
   The original name of this file was ramses_study_LPO_2028_v001_20250328_001.tm.


   \begindata

     PATH_VALUES       = ( '..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/ck/apophis_npa_220101_330101_cuni_A_v1.bc'

                           '$KERNELS/fk/ramses_v00.tf'
                           '$KERNELS/fk/ramses_ops_v00.tf'
                           '$KERNELS/fk/estrack_v04.tf'
                           '$KERNELS/fk/earthfixeditrf93.tf'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/pck/de-403-masses.tpc'
                           '$KERNELS/pck/earth_070425_370426_predict.bpc'
                           '$KERNELS/pck/pck00011.tpc'
                           '$KERNELS/pck/apophis_v01.tpc'

                           '$KERNELS/spk/de432s.bsp'
                           '$KERNELS/spk/estrack_v04.bsp'
                           '$KERNELS/spk/ramses_study_LPO_2028_280421_290324_v01.bsp'
                           '$KERNELS/spk/sb-99942-218.bsp'

                         )

   \begintext


SPICE Kernel Dataset Version
--------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v002_20260206_001'

   \begintext

   The unique identifier for this meta-kernel is provided by the following
   keyword:

   \begindata

      MK_IDENTIFIER = 'ramses_study_LPO_2028_v002_20260206_001'

   \begintext


Contact Information
--------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@cosmos.esa.int,


End of MK file.