KPL/FK

Ramses Spacecraft Frames Kernel
=============================================================================

   This frame kernel contains complete set of frame definitions for the
   Ramses (named after the Greek goddess of marriage) including definitions
   for the Ramses fixed and Ramses science instrument frames. This kernel
   also contains NAIF ID/name mapping for the Ramses science instruments
   and s/c structures (see the last section of the file).


Version and Date
-----------------------------------------------------------------------------

   Version 0.0 -- March 28, 2025 -- Alfredo Escalante Lopez, ESAC/ESA

      Preliminary Version. Only basic ID and frame definitions.


References
-----------------------------------------------------------------------------

   1.   ``Frames Required Reading''

   2.   ``Kernel Pool Required Reading''

   3.   ``C-Kernel Required Reading''


Contact Information
-----------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@cosmos.esa.int

   or NAIF at JPL:

           Boris Semenov
           +1 (818) 354-8136
           Boris.Semenov@jpl.nasa.gov


Implementation Notes
-----------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool".  The SPICELIB
   routine FURNSH loads a kernel into the pool as shown below:

     FORTRAN: (SPICELIB)

       CALL FURNSH ( frame_kernel_name )

     C: (CSPICE)

       furnsh_c ( frame_kernel_name );

     IDL: (ICY)

       cspice_furnsh, frame_kernel_name

     MATLAB: (MICE)

       cspice_furnsh ( 'frame_kernel_name' )

     PYTHON: (SPICEYPY)*

       furnsh( frame_kernel_name )

   In order for a program or routine to extract data from the pool, the
   SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
   more details.

   This file was created and may be updated with a text editor or word
   processor.

   * SPICEPY is a non-official, community developed Python wrapper for the
     NAIF SPICE toolkit. Its development is managed on Github.
     It is available at: https://github.com/AndrewAnnex/SpiceyPy


Ramses Mission NAIF ID Codes
-----------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the Ramses spacecraft,
   its structures and science instruments (the keywords implementing these
   definitions are located in the section "Ramses Mission NAIF ID
   Codes -- Definition Section" at the end of this file):

      Ramses Spacecraft and Spacecraft Structures names/IDs:

            RAMSES                      -92

            RAMSES_SPACECRAFT           -92000  (synonym: RAMSES_SC)

      Asteroid names/IDs:

            APOPHIS                     2099942


Ramses Mission Frames
-----------------------------------------------------------------------------

   The following Ramses frames are defined in this kernel file:

           Name                  Relative to               Type       NAIF ID
      ======================  ========================  ==========   =========

    Spacecraft frames:
    ------------------
      RAMSES_SPACECRAFT         J2000                    SWITCH       -92000
      RAMSES_SPACECRAFT_PLAN    J2000                    CK           -92001
      RAMSES_SPACECRAFT_MEAS    J2000                    CK           -92002


   In addition, the following frames, in use by the Ramses mission, are
   defined in other kernels or `built into' the SPICE system:

  Ramses mission specific science frame:
   -------------------------------------------
      APOPHIS_FIXED            J2000                 PCK           -2099942001
      APOPHIS_CK               J2000                 CK            -2099942000

   SPICE 'Built-in' PCK frames in use by BepiColombo (3):
   ------------------------------------------------------
      IAU_EARTH                J2000                     PCK        built-in

      (3) Data for these frames is loaded using either the PCK file
          "pckVVVVV.tpc" (VVVVV is the version number)


Ramses Frames Hierarchy
-----------------------------------------------------------------------------

  The diagram below shows the Ramses spacecraft and its structures frame
  hierarchy (not including science instrument frames.)

                          "J2000" INERTIAL
         +-------------------+----------------+
         |          |        |                |
         |<-pck     |        |<-ck            |<-pck
         |          |        |                |
         V          |        V                V
   "EARTH_FIXED"    |    "APOPHIS_CK"   "APOPHIS_FIXED"
   -------------    |    ------------   ---------------
                    |
                    |<-ck
                    |
                    V
          "RAMSES_SPACECRAFT"
      +------------------------+
      |                        .
      |<-fixed                 .
      |                        .
      V                        .
   "RAMSES_HGA"                .
   ------------                .
                               .
                               V
         Individual instrument frame trees are provided
         in the corresponding sections of this file


Ramses Target Frames
========================================================================

   This section of the file contains the body-fixed frame definition
   for one of the Ramses mission targets: asteroid Apophis.

   A body-fixed frame is defined for Apophis using standard body-fixed,
   PCK-based frame formation rules:

      -  +Z axis is toward the North pole;

      -  +X axis is toward the prime meridian;

      -  +Y axis completes the right hand frame;

      -  the origin of this frame is at the center of the body.

   The orientation of this frame is computed by evaluating
   corresponding rotation constants provided in the PCK file(s).

   \begindata

      FRAME_APOPHIS_FIXED        = -2099942001
      FRAME_-2099942001_NAME     = 'APOPHIS_FIXED'
      FRAME_-2099942001_CLASS    =  2
      FRAME_-2099942001_CLASS_ID = -2099942001
      FRAME_-2099942001_CENTER   = 2099942
      OBJECT_-2099942001_FRAME   = 'APOPHIS_FIXED'

   \begintext


   Because the orientation of Apophis cannot be represented over long
   periods of time using the standard IAU body rotation formulation, a
   body-fixed CK-based frame, APOPHIS_CK, is defined for the asteroid.
   The orientation of this frame is computed using data provided in CK
   files for ID -2099942000, tagged with encoded ticks of the artificial
   SCLK with ID -2099942. The SCLK data supporting conversions between
   these ticks and Ephemeris Time are provided next to the APOPHIS_CK
   frame definition below.

   The APOPHIS_CK is the preferred body-fixed frame for the asteroid in
   all cases when the asteroid orientation CKs are available.

   As all other body-fixed frames, this frame has its axes and center
   aligned according to the standard body-fixed frame formation rules:

      -  +Z axis is toward the North pole;

      -  +X axis is toward the prime meridian;

      -  +Y axis completes the right handed frame;

      -  the origin of this frame is at the center of the body.

   The keywords below define the CK-based frame and accompanying SCLK
   parameters.

   \begindata

      FRAME_APOPHIS_CK                 = -2099942000
      FRAME_-2099942000_NAME           = 'APOPHIS_CK'
      FRAME_-2099942000_CLASS          =  3
      FRAME_-2099942000_CLASS_ID       = -2099942000
      FRAME_-2099942000_CENTER         =  2099942
      CK_-2099942000_SCLK              = -2099942
      CK_-2099942000_SPK               =  2099942

      SCLK_KERNEL_ID                   = ( @2021-06-17/12:00:00 )
      SCLK_DATA_TYPE_2099942           = ( 1 )
      SCLK01_TIME_SYSTEM_2099942       = ( 1 )
      SCLK01_N_FIELDS_2099942          = ( 2 )
      SCLK01_MODULI_2099942            = ( 3155760000 1000 )
      SCLK01_OFFSETS_2099942           = ( 0 0 )
      SCLK01_OUTPUT_DELIM_2099942      = ( 1 )
      SCLK_PARTITION_START_2099942     = ( 0.00000E+00 )
      SCLK_PARTITION_END_2099942       = ( 3.15576E+12 )
      SCLK01_COEFFICIENTS_2099942      = ( 0.0 @2000-JAN-01-12:00:00.000 1.0 )

   \begintext


Ramses Spacecraft and Spacecraft Structures Frames
========================================================================

   This section of the file contains the definitions of the spacecraft
   and spacecraft structures frames.


Ramses Spacecraft Frame
--------------------------------------

   The Ramses spacecraft frame is defined as follows:

      -  +Z axis is along the nominal boresight direction of the asteroid
         framing camera;

      -  +X axis is along the nominal boresight direction of the HGA;

      -  +Y axis completes the right-hand frame;

      -  the origin of this frame is the launch vehicle interface point.

   These diagrams illustrate the RAMSES_SPACECRAFT frame:


   +X s/c side (HGA side) view:
   ----------------------------

                                      ^
                                      | toward asteroid
                                      |

                                 Science Deck

   .__  __..___________.     .__________________    .___________..__  ___.
   |  / / ||           |\   |        ____      |   /|           ||  / /  |
   |  / / ||           | \  .      .'    `.    .  / |           ||  \ \  |
   |  \ \ ||           |  \ |     /    |   \   | /  |           ||  / /  |
   |  / / ||           |   o|     |  _ O   |   |o   |           ||  \ \  |
   |  \ \ ||           |  / |    +Zsc ^ \  /   | \  |           ||  / /  |
   |  / / ||           | /  |      `._|__.'    |  \ |           ||  / /  |
   .__\ \_..___________./   ._________|________.   \.___________..__\ \__.
                                   /\ | /\
                                      o-------> +Ysc
                                     +Xsc
                                                       +Xsc is out of
                                                        the page.


   +Z s/c side (science deck side) view:
   -------------------------------------

                             .________________.
                             |                |
                             |           +Ysc |
   o==/ /==-=============---o|   +Zsc o-----> |o---===============-=/ /==o
       -Y Solar Array        |        |       |               +Y Solar Array
                             .________|_______.
                                   .--V +Xsc
                            HGA  .'       `.
                                /___________\
                                    `.|.'                 +Zsc is out
                                                           of the page.


   The s/c bus attitude with respect to an inertial frame is provided
   by a Switch Frame (see [1] for more information) aligned with one of
   the different CK-based base frames (RAMSES_SPACECRAFT_MEAS or
   RAMSES_SPACECRAFT_PLAN) depending on coverage. RAMSES_SPACECRAFT_MEAS
   has priority over RAMSES_SPACECRAFT_PLAN whenever coverage for both
   is available.

   \begindata

      FRAME_RAMSES_SPACECRAFT      = -92000
      FRAME_-92000_NAME            = 'RAMSES_SPACECRAFT'
      FRAME_-92000_CLASS           =  6
      FRAME_-92000_CLASS_ID        = -92000
      FRAME_-92000_CENTER          = -92000
      FRAME_-92000_ALIGNED_WITH    = (
                                       'RAMSES_APOPHIS_NPO'
                                       'RAMSES_SPACECRAFT_PLAN'
                                       'RAMSES_SPACECRAFT_MEAS'
                                      )

   \begintext


   The RAMSES spacecraft planning reference frame -- RAMSES_SPACECRAFT_PLAN --
   is defined in order to accommodate the C-kernels that have been generated
   with a fictional SCLK kernel. These CK kernels contain predicted and test
   data and are used for planning purposes.

   The before-mentioned CKs are generated with a fictional SCLK kernel due to
   the fact that successive updates of the real SCLK kernel would lead to
   erroneous results for the predicted data provided by those kernels after
   the last Time Correlation Packet offered by the real SCLK.

   Since the s/c bus predicted attitude is defined with respect to an inertial
   frame and provided by a C-kernel (see [3] for more information), this frame
   is defined as a CK-based frame. These sets of keywords define the
   RAMSES_SPACECRAFT_PLAN frame.

   \begindata

      FRAME_RAMSES_SPACECRAFT_PLAN    = -92001
      FRAME_-92001_NAME               = 'RAMSES_SPACECRAFT_PLAN'
      FRAME_-92001_CLASS              =  3
      FRAME_-92001_CLASS_ID           = -92001
      FRAME_-92001_CENTER             = -92000
      CK_-92001_SCLK                  = -92999
      CK_-92001_SPK                   = -92

   \begintext


   The RAMSES spacecraft measured reference frame -- RAMSES_SPACECRAFT_MEAS --
   is defined in order to accommodate the C-kernels that have been generated
   with a real SCLK kernel. These C-kernels contain measured data from the
   housekeeping telemetry (commanded or as-flown) and are mainly used for
   data analysis.

   Since the s/c bus measured attitude is defined with respect to an inertial
   frame and provided by a C-kernel (see [3] for more information), this frame
   is defined as a CK-based frame.

   \begindata

      FRAME_RAMSES_SPACECRAFT_MEAS  = -92002
      FRAME_-92002_NAME             = 'RAMSES_SPACECRAFT_MEAS'
      FRAME_-92002_CLASS            =  3
      FRAME_-92002_CLASS_ID         = -92002
      FRAME_-92002_CENTER           = -92000
      CK_-92002_SCLK                = -92
      CK_-92002_SPK                 = -92

   \begintext


Ramses NAIF ID Codes to Name Mapping
------------------------------------------------------------------------------

   This section contains name to NAIF ID mappings for the Ramses mission.
   Once the contents of this file is loaded into the KERNEL POOL,
   these mappings become available within SPICE, making it possible to use
   names instead of ID code in the high level SPICE routine calls.

  Spacecraft:
  ----------------------------------------------------------------

      This table presents the Ramses Spacecraft and its main
      structures' names.

      ---------------------  -------  --------------------------
       Name                   ID       Synonyms
      ---------------------  -------  --------------------------
       RAMSES                    -92
       RAMSES_SPACECRAFT      -92000   RAMSES_SC
      ---------------------  -------  --------------------------

      Notes:

         -- 'RAMSES_SC' and 'RAMSES_SPACECRAFT' are synonyms and all map to the
            Ramses s/c bus structure ID (-92000);

     \begindata

        NAIF_BODY_NAME += ( 'RAMSES'                          )
        NAIF_BODY_CODE += ( -92                               )

        NAIF_BODY_NAME += ( 'RAMSES_SC'                       )
        NAIF_BODY_CODE += ( -92000                            )

        NAIF_BODY_NAME += ( 'RAMSES_SPACECRAFT'               )
        NAIF_BODY_CODE += ( -92000                            )

     \begintext


  Asteroid:
  ----------------------------------------------------------------

      This table presents the Ramses target names.

      -------------------------  --------  --------------------------
       Name                       ID        Synonyms
      -------------------------  --------  --------------------------
       APOPHIS                   2099942
      -------------------------  --------  --------------------------

     \begindata

        NAIF_BODY_NAME += ( '99942 APOPHIS (2004 MN4)' )
        NAIF_BODY_CODE += ( 2099942 )

        NAIF_BODY_NAME += ( '99942 APOPHIS' )
        NAIF_BODY_CODE += ( 2099942 )

        NAIF_BODY_NAME += ( 'APOPHIS' )
        NAIF_BODY_CODE += ( 2099942 )

   \begintext


End of FK file.