KPL/FK

Frame (FK) SPICE kernel file for Ramses science operations frames
===============================================================================

   This frames kernel defines a number of frames used by the Ramses
   science operations centre to perform mission analysis and attitude
   dependent science opportunity identification.

   These frames can be used stand-alone, i.e. referring directly to them and
   assuming they correspond to the Ramses spacecraft reference frame, or
   in combination with the Ramses spacecraft frames. The latter will allow the
   user to use the existing alignments and instrument frame definitions to
   perform instrument specific mission analysis and attitude dependent
   science opportunity identification. Please refer to the section ``Using
   these frames'' for further details.


Version and Date
-------------------------------------------------------------------------------

   Version 0.0 -- March 28, 2025 -- Alfredo Escalante Lopez, ESAC/ESA

      Initial version.


References
-------------------------------------------------------------------------------

   [1]   "Frames Required Reading"

   [2]   "Kernel Pool Required Reading"


Contact Information
-----------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service at ESAC:

           Alfredo Escalante Lopez
           (+34) 91-8131-429
           spice@sciops.esa.int

   or NAIF at JPL:

           Boris Semenov
           +1 (818) 354-8136
           Boris.Semenov@jpl.nasa.gov


Implementation Notes
-------------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool".  The SPICELIB
   routine FURNSH loads a kernel into the pool as shown below:

     FORTRAN: (SPICELIB)

       CALL FURNSH ( frame_kernel_name )

     C: (CSPICE)

       furnsh_c ( frame_kernel_name );

     IDL: (ICY)

       cspice_furnsh, frame_kernel_name

     MATLAB: (MICE)

       cspice_furnsh ( 'frame_kernel_name' )

     PYTHON: (SPICEYPY)*

       furnsh( frame_kernel_name )

   In order for a program or routine to extract data from the pool, the
   SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
   more details.

   This file was created and may be updated with a text editor or word
   processor.

   * SPICEPY is a non-official, community developed Python wrapper for the
     NAIF SPICE toolkit. Its development is managed on Github.
     It is available at: https://github.com/AndrewAnnex/SpiceyPy


Ramses Science Operations frame names and NAIF ID Codes
-------------------------------------------------------------------------------

   The following frame is defined in this kernel file:

      SPICE Frame Name          Long-name
      ------------------------  ---------------------------------------------
      RAMSES_APOPHIS_NPO        Ramses Apophis Nadir power-optimized pointing


   These frame has the following centers, frame class and NAIF
   ID:

      SPICE Frame Name          Center                 Class     NAIF ID
      ------------------------  ---------------------  -------  ---------
      RAMSES_APOPHIS_NPO        RAMSES                 DYNAMIC   -92912


General Notes About This File
-------------------------------------------------------------------------------

   About Required Data:
   --------------------
   All the dynamic frames defined in this file require at least one
   of the following kernel types to be loaded prior to their evaluation,
   normally during program initialization:

     - Planetary and Satellite ephemeris data (SPK), i.e. de432, de405, etc;
     - Spacecraft ephemeris data (SPK);

   Note that loading different kernels will lead to different
   orientations of the same frame at a given epoch, providing different
   results from each other, in terms of state vectors referred to these
   frames.


   Using these frames
   ------------------
   These frames have been implemented to define the different pointing
   profiles for the Ramses spacecraft. These pointing profiles can be
   used in two different ways:

      [1] ``As is'' for analysis of offsets between the spacecraft
          attitude defined in the corresponding CK and a given pointing
          profile. Loading this kernel in combination with any Ramses CK
          will allow the user to perform this comparison between the
          RAMSES_SPACECRAFT frame and any of the different frames defined
          within this kernel.

      [2] In combination with the Ramses Frames kernel, to define
          a default pointing profile for the whole duration of the mission
          together with the spacecraft and instrument frames defined in the
          Ramses FK. In this way, instrument-specific mission analysis
          activities, for which a particular pointing profile and knowledge
          of the instruments is required, can be conducted without the need
          for a spacecraft CK.

          In order to define such default pointing profile, the latest
          Ramses frames kernel and this file shall be loaded before the
          selected ``Ramses spacecraft frame overwrite'' frame kernel. As
          an example, imagine that the desired default pointing profile is
          "Nadir power optimized with respect to Apophis", then the furnish
          (metakernel) file should contain the following sequence of frames
          kernels, in the following order:

              ...

              $DATA/fk/ramses_v00.tf
              $DATA/fk/ramses_ops_v00.tf
              $DATA/fk/ramses_sc_apophis_npo_v00.tf

              ...

            (*) the example presents version 0.0 of the Ramses frames
            and Ramses Science Operations frames kernels. Newer versions of
            these files will produce the same results.

          By loading the ``ramses_sc_apophis_npo_vNN.tf'' frames kernel last,
          the spacecraft frame RAMSES_SPACECRAFT, which is defined as a CK-based
          frame in the ``Ramses frames kernel'', will be overwritten as a
          type-4 fixed offset frame, mapping the RAMSES_SPACECRAFT frame to
          the RAMSES_APOPHIS_NPO frame defined in the ``Ramses Science
          Operations Frames Kernel'' (this) file.


Ramses Science Operations Frame Definitions
-------------------------------------------------------------------------------

   This section contains the definition of the Ramses science operations
   frames.


Ramses Apophis Nadir power-optimized pointing frame (RAMSES_APOPHIS_NPO)
---------------------------------------------------------------------

   Definition:
   -----------
   The Ramses Apophis Nadir power-optimized pointing frame is defined as
   follows:

      -  +Z axis is the primary vector and points from Ramses to the
         center of Apophis (Nadir direction);

      -  +X axis is the secondary vector and points from Ramses to the Sun;

      -  +Y axis completes the right-handed system;

      -  the original of this frame is the spacecraft's center of mass.

   All vectors are geometric: no corrections are used.


   Required Data:
   --------------
   This frame is defined as a two-vector frame.

   Both the primary and the secondary vector are defined as an
   'observer-target position' vectors, therefore, the ephemeris data
   required to compute both the Ramses-Apophis position and the Ramses-Sun
   position in J2000 frame have to be loaded before using this frame.


   Remarks:
   --------
   Since the primary and secondary vectors of this frame are defined
   based on the Ramses-Apophis position and Ramses-Sun position vectors, the usage
   of different ephemerides to compute these vectors may lead to different
   frame orientation at given time.

   \begindata

      FRAME_RAMSES_APOPHIS_NPO     = -92912
      FRAME_-92912_NAME            = 'RAMSES_APOPHIS_NPO'
      FRAME_-92912_CLASS           =  5
      FRAME_-92912_CLASS_ID        = -92912
      FRAME_-92912_CENTER          = -92
      FRAME_-92912_RELATIVE        = 'J2000'
      FRAME_-92912_DEF_STYLE       = 'PARAMETERIZED'
      FRAME_-92912_FAMILY          = 'TWO-VECTOR'
      FRAME_-92912_PRI_AXIS        = 'Z'
      FRAME_-92912_PRI_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_-92912_PRI_OBSERVER    = 'RAMSES'
      FRAME_-92912_PRI_TARGET      = 'APOPHIS'
      FRAME_-92912_PRI_ABCORR      = 'NONE'
      FRAME_-92912_SEC_AXIS        = 'X'
      FRAME_-92912_SEC_VECTOR_DEF  = 'OBSERVER_TARGET_POSITION'
      FRAME_-92912_SEC_OBSERVER    = 'RAMSES'
      FRAME_-92912_SEC_TARGET      = 'SUN'
      FRAME_-92912_SEC_ABCORR      = 'NONE'
      FRAME_-92912_SEC_FRAME       = 'J2000'

   \begintext


End of FK file.